﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace LINQ_to_XML
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }

        private void UtworzPlikXML_WersjaDluga()
        {
            //definiowanie obiektów
            XDocument xml = new XDocument();
            XDeclaration deklaracja = new XDeclaration("1.0", "utf-8", "yes");
            XComment komentarz = new XComment("Parametry aplikacji");
            XElement opcje = new XElement("opcje");
            XElement okno = new XElement("okno");
            XAttribute nazwa = new XAttribute("nazwa", this.Text);
            XElement pozycja = new XElement("pozycja");
            XElement X = new XElement("X", this.Left);
            XElement Y = new XElement("Y", this.Top);
            XElement wielkość = new XElement("wielkość");
            XElement Szer = new XElement("Szer", this.Width);
            XElement Wys = new XElement("Wys", this.Height);
            
            //budowanie drzewa (od gałęzi)
            pozycja.Add(X);
            pozycja.Add(Y);
            wielkość.Add(Szer);
            wielkość.Add(Wys);
            okno.Add(nazwa);
            okno.Add(pozycja);
            okno.Add(wielkość);
            opcje.Add(okno);

            xml.Declaration=deklaracja;
            xml.Add(komentarz);
            xml.Add(opcje);           

            //zapis do pliku
            xml.Save("Ustawienia.xml");
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XComment("Parametry aplikacji"),
                new XElement("opcje",
                    new XElement("okno",
                        new XAttribute("nazwa", this.Text),
                        new XElement("pozycja",
                            new XElement("X", this.Left),
                            new XElement("Y", this.Top)
                        ),
                        new XElement("wielkość",
                            new XElement("Szer", this.Width),
                            new XElement("Wys", this.Height)
                        )
                    )
                )
            );

            xml.Save("Ustawienia.xml");
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                XDocument xml = XDocument.Load("Ustawienia.xml");

                //odczytanie tytułu okna
                this.Text = xml.Root.Element("okno").Attribute("nazwa").Value;

                //odczytanie pozycji i wielkości
                XElement pozycja = xml.Root.Element("okno").Element("pozycja");
                this.Left = int.Parse(pozycja.Element("X").Value);
                this.Top = int.Parse(pozycja.Element("Y").Value);

                XElement wielkość = xml.Root.Element("okno").Element("wielkość");
                this.Width = int.Parse(wielkość.Element("Szer").Value);
                this.Height = int.Parse(wielkość.Element("Wys").Value);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd podczas odczytywania pliku XML:\n" + exc.Message);
            }

            textBox1.Text = this.Text;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            this.Text = textBox1.Text;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            XDocument xml = XDocument.Load("Ustawienia.xml");

            //wersja XML
            string wersja = xml.Declaration.Version;
            MessageBox.Show("Wersja XML: " + wersja);            

            //odczytanie nazwy głównego elementu
            string nazwaElementuGlownego = xml.Root.Name.LocalName;
            MessageBox.Show("Nazwa elementu głównego: " + nazwaElementuGlownego);

            //kolekcja podelementów ze wszystkich poziomów drzewa
            IEnumerable<XElement> wszystkiePodelementy = xml.Root.Descendants();
            string s = "Wszystkie podelementy:\n";
            foreach (XElement podelement in wszystkiePodelementy) s += podelement.Name + "\n";
            MessageBox.Show(s);

            //kolekcja podelementow elementu okno
            IEnumerable<XElement> podelementyOkno = xml.Root.Element("okno").Elements();
            s = "Podelementy elementu okno:\n";
            foreach (XElement podelement in podelementyOkno) s += podelement.Name + "\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            XDocument xml = XDocument.Load("Ustawienia.xml");
            var cos = from element in xml.Descendants() where element.Name == "X" select element;
            int ile=cos.Count();
            MessageBox.Show(ile.ToString());
            string s = "Wartości elementów:\n";
            foreach (XElement element in cos) s += element.Value;
            MessageBox.Show(s);
        }
    }
}
